/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.hsc.websm.sysprofile;

import com.ibm.hsc.auiml.databeans.sysprofile.PISystemProfBean;
import com.ibm.hsc.auiml.databeans.sysprofile.PISystemProfButtonHandler;
import com.ibm.hsc.client.PISysProfDataBean;
import com.ibm.hsc.common.bundles.HSCResourceBundleUtil;
import com.ibm.hsc.common.exceptions.PIHscClientException;
import com.ibm.hsc.common.util.AuimlAdapter;
import com.ibm.hsc.common.util.PIHscUtil;
import com.ibm.hsc.websm.common.WSMCommonUtil;
import com.ibm.ui.framework.DataBean;
import com.ibm.ui.framework.IllegalUserDataException;
import com.ibm.ui.framework.ItemDescriptor;
import com.ibm.ui.framework.TaskActionEvent;
import com.ibm.ui.framework.TaskActionListener;
import com.ibm.ui.framework.TaskManagerException;
import com.ibm.ui.framework.TaskMessage;
import com.ibm.ui.framework.TaskSelectionListener;
import com.ibm.ui.framework.UserTaskManager;
import com.ibm.websm.diagnostics.IDebug;
import com.ibm.websm.mobject.MOClass;
import com.ibm.websm.mobject.MOXContainerObj;
import java.util.ArrayList;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.Vector;

public class PISystemProfileDialog
implements TaskActionListener {
    public static final boolean READ_ONLY = false;
    public static final boolean WRITE = true;
    public static final int CREATE = 0;
    public static final int PROPERTIES = 1;
    public static final String GET_PARTITION_PROFILES = "getPartitionProfileList";
    public static final String GET_SYSPROF_NAMES = "getSystemProfileNames";
    public static final String GET_SYSPROF_BEAN = "getSysProfDataBean";
    public static final String CREATE_SYSPROF = "createSystemProfile";
    public static final String MODIFY_SYSPROF = "modifySystemProfile";
    public static final String CEC_MOBJECT_CLASS = "com.ibm.hsc.websm.cec.CECMObject";
    public static final String ROW = "ROW";
    private static final String AUIML_DIALOG = "com.ibm.hsc.auiml.databeans.sysprofile.PISystemProfileDialog";
    private static final String OK_BUTTON = "OKButton";
    private static final String SYS_PROF_PANEL = "SystemProfile";
    private static final String LPAR_TREE = "LparTree";
    private static final String DB_STRING = "##### PISystemProfileDialog #####";
    private static final String SYS_PROF_TABLE = "SysProfTable";
    private static final String SYS_PROF_FAILED = "0012";
    private static final String BUNDLE_FILE = "HSCCIMExceptionBundle";
    private static final String PROFILE_BUNDLE_FILE = "ProfileBundle";
    private static final String[] YES_NO_OPTIONS = new String[]{"Yes", "No"};
    private static final String INVOKE_STATIC_METHOD_FAILED = "1971";
    private static final String DUPLICATE_NAME = "09E1";
    private static final String MODIFY_FAILED = "09D4";
    PISystemProfBean m_sysBean;
    MOXContainerObj m_moxObj;
    MOClass m_cecMoxClass;
    MOClass m_sysProfMoxClass;
    UserTaskManager m_utm;
    boolean m_isModified;
    boolean m_mode;
    int m_action;
    String m_moxKey;
    String m_cecId;
    String m_hostName;
    String m_nameSpace;
    String m_cecName;
    String m_sysProfName;
    String m_profId;
    Vector m_sysProfileNames;
    PISysProfDataBean m_cimSysProfBean;

    public PISystemProfileDialog(MOXContainerObj mOXContainerObj, boolean bl, int n) {
        this.m_moxObj = mOXContainerObj;
        this.m_moxKey = mOXContainerObj.getKey();
        if (n == 1) {
            Vector vector;
            this.m_sysProfMoxClass = this.m_moxObj.getMOClass();
            this.m_sysProfName = this.m_moxObj.getName();
            this.m_profId = WSMCommonUtil.getSysProfId(this.m_moxKey);
            Vector vector2 = this.m_moxObj.getParents("parent_child");
            if (vector2 != null && vector2.size() > 0 && (vector = ((MOXContainerObj)vector2.elementAt(0)).getParents("parent_child")) != null && vector.size() > 0) {
                this.m_cecMoxClass = ((MOXContainerObj)vector.elementAt(0)).getMOClass();
                this.m_cecName = ((MOXContainerObj)vector.elementAt(0)).getName();
            }
        } else {
            this.m_cecMoxClass = this.m_moxObj.getMOClass();
            this.m_cecName = this.m_moxObj.getName();
        }
        this.m_cecId = this.m_moxKey.substring(0, this.m_moxKey.indexOf("~"));
        this.m_mode = bl;
        this.m_action = n;
        this.m_hostName = this.m_moxObj.getHost().getName();
        this.m_nameSpace = (String)this.m_moxObj.getPropertyValue("nameSpace_Prop");
        this.m_sysBean = new PISystemProfBean();
        if (IDebug.enabled()) {
            System.err.println("##### PISystemProfileDialog ##### *********** Constructor Summary ***********");
            System.err.println(" MoxObj : " + this.m_moxObj + " CECMOClass : " + this.m_cecMoxClass + " MSYSProfMOClass : " + this.m_sysProfMoxClass + " Mode : " + bl + " Action : " + this.m_action + " CECId : " + this.m_cecId + " Prof Id :" + this.m_profId + " HostName : " + this.m_hostName + " NameSpace : " + this.m_nameSpace + " CEC Name : " + this.m_cecName + " Sys ProfName: " + this.m_sysProfName);
        }
    }

    public void showDialog() {
        block6: {
            DataBean[] dataBeanArray = new DataBean[]{this.m_sysBean};
            try {
                AuimlAdapter auimlAdapter = new AuimlAdapter(AUIML_DIALOG, SYS_PROF_PANEL, dataBeanArray);
                this.m_sysBean.load();
                this.m_utm = auimlAdapter.getUserTaskManager();
                PISystemProfButtonHandler pISystemProfButtonHandler = new PISystemProfButtonHandler(this.m_sysBean, this.m_utm);
                try {
                    this.loadBean();
                }
                catch (PIHscClientException pIHscClientException) {
                    TaskMessage taskMessage = new TaskMessage(this.m_utm, pIHscClientException.getMessage(), 1);
                    taskMessage.invoke();
                    return;
                }
                if (!this.m_mode) {
                    this.m_utm.setEnabled("AddButton", false);
                    this.m_utm.setEnabled("RemoveButton", false);
                } else {
                    this.m_utm.addTaskActionListener((TaskActionListener)pISystemProfButtonHandler);
                    this.m_utm.addTaskSelectionListener((TaskSelectionListener)this.m_sysBean, SYS_PROF_TABLE);
                    this.m_utm.setEnabled("AddButton", false);
                    this.m_utm.setEnabled("RemoveButton", false);
                    this.m_utm.addTaskActionListener((TaskActionListener)this);
                    this.m_sysBean.setUTM(this.m_utm);
                }
                auimlAdapter.showIt();
            }
            catch (TaskManagerException taskManagerException) {
                if (!IDebug.enabled()) break block6;
                System.err.println("##### PISystemProfileDialog ##### showDialog() >>>>> TaskManagerException caught....");
                taskManagerException.printStackTrace();
            }
        }
    }

    private void loadBean() throws PIHscClientException {
        if (this.m_cecName == null) {
            this.m_cecName = this.m_cecId;
        }
        this.m_sysBean.setServerName(this.m_cecName);
        this.getSysPartitionInfo();
        if (this.m_action == 1) {
            this.modifySysProf();
        }
    }

    private void modifySysProf() throws PIHscClientException {
        ItemDescriptor[] itemDescriptorArray = new ItemDescriptor[]{};
        ItemDescriptor[] itemDescriptorArray2 = new ItemDescriptor[]{};
        try {
            Object[] objectArray = new Object[]{this.m_cecId, this.m_sysProfName, this.m_nameSpace, this.m_hostName};
            this.m_cimSysProfBean = (PISysProfDataBean)this.m_sysProfMoxClass.invokeStaticMethod(GET_SYSPROF_BEAN, objectArray);
        }
        catch (PIHscClientException pIHscClientException) {
            if (IDebug.enabled()) {
                System.err.println("##### PISystemProfileDialog ##### modifySysProf()>>>>>>");
                System.err.println("PIHscClientException caught retrieving system profile names");
                pIHscClientException.printStackTrace();
            }
            throw pIHscClientException;
        }
        catch (Exception exception) {
            if (IDebug.enabled()) {
                System.err.println("##### PISystemProfileDialog ##### modifySysProf() >>>>>>>");
                System.err.println("Throwable caught invoking static method .....");
                exception.printStackTrace();
            }
            throw new PIHscClientException(INVOKE_STATIC_METHOD_FAILED, BUNDLE_FILE, INVOKE_STATIC_METHOD_FAILED);
        }
        if (this.m_cimSysProfBean != null) {
            this.m_sysBean.setSysProfName(this.m_cimSysProfBean.getName());
            String[] stringArray = this.m_cimSysProfBean.getPartNames();
            String[] stringArray2 = this.m_cimSysProfBean.getPartIDs();
            String[] stringArray3 = this.m_cimSysProfBean.getProfNames();
            if (stringArray == null || stringArray2 == null || stringArray3 == null) {
                throw new PIHscClientException(SYS_PROF_FAILED, BUNDLE_FILE, SYS_PROF_FAILED);
            }
            ArrayList arrayList = new ArrayList();
            ArrayList arrayList2 = new ArrayList();
            for (int i = 0; i < stringArray.length; ++i) {
                String string = stringArray[i];
                String string2 = stringArray2[i];
                String string3 = stringArray3[i];
                string = string + "(" + string2 + ")";
                this.m_sysBean.addLparToList(string, string3);
            }
            this.m_sysBean.setSysProfName(this.m_sysProfName);
            this.m_sysBean.setNameModified(false);
        }
    }

    private void getSysPartitionInfo() throws PIHscClientException {
        Hashtable hashtable = null;
        Object[] objectArray = new Object[]{this.m_cecId, this.m_nameSpace};
        try {
            hashtable = (Hashtable)this.m_cecMoxClass.invokeStaticMethod(GET_PARTITION_PROFILES, objectArray);
            this.m_sysProfileNames = (Vector)this.m_cecMoxClass.invokeStaticMethod(GET_SYSPROF_NAMES, objectArray);
        }
        catch (PIHscClientException pIHscClientException) {
            if (IDebug.enabled()) {
                System.err.println("##### PISystemProfileDialog ##### createSysProf()>>>> PIHscClientException");
                pIHscClientException.printStackTrace();
            }
            throw pIHscClientException;
        }
        catch (Throwable throwable) {
            if (IDebug.enabled()) {
                System.err.println("##### PISystemProfileDialog ##### getSysPartitionInfo()>>>> Throwable");
                throwable.printStackTrace();
            }
            throw new PIHscClientException(INVOKE_STATIC_METHOD_FAILED, BUNDLE_FILE, INVOKE_STATIC_METHOD_FAILED);
        }
        if (hashtable != null) {
            this.m_sysBean.setTreeMap(hashtable);
        }
    }

    private boolean _checkName() {
        if (this.m_sysBean.isNameModified()) {
            String string = this.m_sysBean.getSysProfName();
            Iterator iterator = this.m_sysProfileNames.iterator();
            while (iterator.hasNext()) {
                if (!string.equals((String)iterator.next())) continue;
                String[] stringArray = new String[]{string};
                PIHscClientException pIHscClientException = new PIHscClientException(DUPLICATE_NAME, BUNDLE_FILE, DUPLICATE_NAME, stringArray);
                TaskMessage taskMessage = new TaskMessage(this.m_utm, pIHscClientException.getMessage(), 1);
                taskMessage.invoke();
                return false;
            }
        }
        return true;
    }

    public void actionPerformed(TaskActionEvent taskActionEvent) {
        ArrayList arrayList = new ArrayList();
        ArrayList arrayList2 = new ArrayList();
        try {
            this.m_utm.storeAllElements();
        }
        catch (IllegalUserDataException illegalUserDataException) {
            return;
        }
        if (!this._checkName()) {
            return;
        }
        try {
            if (OK_BUTTON.equals(taskActionEvent.getElementName())) {
                if (this.m_action == 0) {
                    System.err.println(" Action is create.....");
                    if (!this._createSysProfile()) {
                        return;
                    }
                }
                if (this.m_action == 1) {
                    System.err.println(" Action is modify....");
                    if (!this._modifySysProfile()) {
                        return;
                    }
                }
            }
        }
        catch (Throwable throwable) {
            if (this.m_action == 0) {
                PIHscUtil.handleExcep(this.m_utm, throwable, BUNDLE_FILE, "09D5", (String)null, (Object[])null);
            }
            PIHscUtil.handleExcep(this.m_utm, throwable, BUNDLE_FILE, MODIFY_FAILED, (String)null, (Object[])null);
        }
        this.m_utm.dispose();
    }

    private boolean _createSysProfile() throws Throwable {
        Object object;
        ArrayList<Object> arrayList = new ArrayList<Object>();
        ArrayList arrayList2 = new ArrayList();
        ArrayList arrayList3 = this.m_sysBean.getSysProfLparList();
        Iterator iterator = arrayList3.iterator();
        while (iterator.hasNext()) {
            object = (String)iterator.next();
            object = ((String)object).substring(0, ((String)object).indexOf("("));
            arrayList.add(object);
        }
        arrayList2 = this.m_sysBean.getSysProfProfileList();
        if (arrayList.size() == 0) {
            object = new TaskMessage(this.m_utm, HSCResourceBundleUtil.getMessage(PROFILE_BUNDLE_FILE, "EMPTY_SYS_PROFILE_MSG"), "NEW_SYS_PROFILE", 3, null, null);
            object.invoke();
            return false;
        }
        object = new PISysProfDataBean();
        ((PISysProfDataBean)object).setName(this.m_sysBean.getSysProfName());
        ((PISysProfDataBean)object).setPartNames(arrayList.toArray(new String[0]));
        ((PISysProfDataBean)object).setProfNames(arrayList2.toArray(new String[0]));
        Object[] objectArray = new Object[]{this.m_cecId, object, this.m_hostName, this.m_nameSpace};
        try {
            this.m_cecMoxClass.invokeStaticMethod(CREATE_SYSPROF, objectArray);
        }
        catch (PIHscClientException pIHscClientException) {
            if (IDebug.enabled()) {
                System.err.println("##### PISystemProfileDialog ##### actionPerformed()>>>");
                System.err.println("PIHscClientException caught.....");
                pIHscClientException.printStackTrace();
            }
            throw pIHscClientException;
        }
        catch (Throwable throwable) {
            System.err.println("Throwable caught............");
            if (IDebug.enabled()) {
                System.err.println("##### PISystemProfileDialog ##### actionPerformed()>>>");
                System.err.println("Throwable caught.................");
                throwable.printStackTrace();
            }
            throw throwable;
        }
        return true;
    }

    private boolean _modifySysProfile() throws Throwable {
        Cloneable cloneable;
        Object object;
        if (this.m_sysBean.isNameModified()) {
            block16: {
                object = this.m_moxObj.getMObject();
                cloneable = new Hashtable<String, String>();
                ((Hashtable)cloneable).put("name", this.m_sysBean.getSysProfName());
                if (object != null) {
                    try {
                        object.setPropertyValues((Hashtable)cloneable, (String)null, null);
                    }
                    catch (Throwable throwable) {
                        if (!IDebug.enabled()) break block16;
                        System.err.println("##### PISystemProfileDialog #####action Performed >>>>>");
                        System.err.println("Error changing name ...");
                        throwable.printStackTrace();
                    }
                }
            }
            this.m_cimSysProfBean.setName(this.m_sysBean.getSysProfName());
        }
        if (this.m_sysBean.isSysProfModified()) {
            Object object2;
            object = new ArrayList();
            cloneable = this.m_sysBean.getSysProfLparList();
            Iterator iterator = ((ArrayList)cloneable).iterator();
            while (iterator.hasNext()) {
                object2 = (String)iterator.next();
                object2 = ((String)object2).substring(0, ((String)object2).indexOf("("));
                ((ArrayList)object).add(object2);
            }
            object2 = this.m_sysBean.getSysProfProfileList();
            if (((ArrayList)object).size() == 0) {
                TaskMessage taskMessage = new TaskMessage(this.m_utm, HSCResourceBundleUtil.getMessage(PROFILE_BUNDLE_FILE, "DELETE_EMPTY_SYS_PROFILE_WARNING_MSG"), "MOD_SYS_PROFILE", 4, YES_NO_OPTIONS, null);
                int n = taskMessage.invoke();
                if (n == 1) {
                    System.err.println("No was selected !!!!!");
                    System.err.println("Val is " + n);
                    return false;
                }
                System.err.println("Yes Was selected .....");
                System.err.println("Val is " + n);
            }
            this.m_cimSysProfBean.setPartNames(((ArrayList)object).toArray(new String[0]));
            this.m_cimSysProfBean.setProfNames(((ArrayList)object2).toArray(new String[0]));
        }
        if (this.m_sysBean.isSysProfModified() || this.m_sysBean.isNameModified()) {
            System.err.println("Args for MObject...");
            System.err.println("m_cimSysProfBean " + this.m_cimSysProfBean);
            object = this.m_cimSysProfBean.getPartNames();
            cloneable = this.m_cimSysProfBean.getProfNames();
            if (IDebug.enabled()) {
                System.err.println("Partition/Profile List.....");
                for (int i = 0; i < ((Object)object).length; ++i) {
                    System.err.println((String)object[i] + "/" + (String)((Object)cloneable[i]));
                }
            }
            Object[] objectArray = new Object[]{this.m_cecId, this.m_cimSysProfBean, this.m_sysProfName, this.m_hostName, this.m_nameSpace};
            try {
                this.m_sysProfMoxClass.invokeStaticMethod(MODIFY_SYSPROF, objectArray);
            }
            catch (PIHscClientException pIHscClientException) {
                if (IDebug.enabled()) {
                    System.err.println("##### PISystemProfileDialog ##### actionPerformed()>>>");
                    System.err.println("PIHscClientException caught.....");
                    pIHscClientException.printStackTrace();
                }
                throw pIHscClientException;
            }
            catch (Throwable throwable) {
                if (IDebug.enabled()) {
                    System.err.println("##### PISystemProfileDialog ##### actionPerformed()>>>");
                    System.err.println("Throwable caught.................");
                    throwable.printStackTrace();
                }
                throw throwable;
            }
        }
        return true;
    }
}

